/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_xor5 ( result, data4x, data3x, data2x, data1x, data0x ) ;

  parameter lpm_type = "lpm_xor" ;
  parameter lpm_size = 5 ;
  parameter lpm_width = 1 ;
  parameter polar_data4x = "NORMAL" ;
  parameter polar_data3x = "NORMAL" ;
  parameter polar_data2x = "NORMAL" ;
  parameter polar_data1x = "NORMAL" ;
  parameter polar_data0x = "NORMAL" ;
  parameter polar_result = "NORMAL" ;

  input  [lpm_width-1:0] data4x ;
  input  [lpm_width-1:0] data3x ;
  input  [lpm_width-1:0] data2x ;
  input  [lpm_width-1:0] data1x ;
  input  [lpm_width-1:0] data0x ;
  output [lpm_width-1:0] result ;

  wire  [lpm_width-1:0] data4x,data3x,data2x,data1x,data0x ;
  reg   [lpm_width-1:0] result ;
  reg  [lpm_width-1:0] pdata4x,pdata3x,pdata2x,pdata1x,pdata0x ;

  always @(data4x or data3x or data2x or data1x or data0x)
    begin
       pdata4x = (polar_data4x=="INVERT")?~data4x:data4x ;
       pdata3x = (polar_data3x=="INVERT")?~data3x:data3x ;
       pdata2x = (polar_data2x=="INVERT")?~data2x:data2x ;
       pdata1x = (polar_data1x=="INVERT")?~data1x:data1x ;
       pdata0x = (polar_data0x=="INVERT")?~data0x:data0x ;
    end

  always @(pdata4x or pdata3x or pdata2x or pdata1x or pdata0x)
    begin
       if(polar_result == "INVERT")
          result = ~(pdata4x ^ pdata3x ^ pdata2x ^ pdata1x ^ pdata0x) ;
       else
          result = pdata4x ^ pdata3x ^ pdata2x ^ pdata1x ^ pdata0x ;
    end

endmodule // lpm_xor5
`ifdef SYNTH
`else
`endcelldefine
`endif

